<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

get_header();

if ( have_posts() ) :
    while ( have_posts() ) : the_post();

?>

<section>
    <div class="container px-0 py-0">
        <div class="result-wrapper bg-color-1 px-4 py-4">
            <h3 class="d-none d-lg-block page-title text-white text-uppercase py-3">
                <span><?php echo get_the_title(); ?></span>
            </h3>
            <h5 class="d-block d-lg-none page-title text-white text-uppercase py-3">
                <span><?php echo get_the_title(); ?></span>
            </h5>
        </div>
    </div>
</section>

<section class="content-wrapper">
    <div class="container px-0 py-0">
        <div class="content content-home bg-color-2 text-white text-justify px-3 py-3 px-lg-4 py-lg-4">
            <?php the_content(); ?>
            <hr class="my-3 border-light border-dashed">
            <div class="tags-wrapper">
                <p class="text-white text-left mb-1">Tags :</p>
                <?php if ( !empty( get_the_tags() ) ) : foreach ( get_the_tags() as $tag ) : ?>
                    <a href="<?php echo get_tag_link( $tag->term_id ); ?>" class="badge badge-dark text-white font-weight-normal px-2 py-2 mb-0 mt-1"><?php echo $tag->name; ?></a>
                <?php endforeach; endif; ?>
            </div>
        </div>
    </div>
</section>

<?php

    endwhile;
endif;

get_footer();
