<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

global $paged;

if (get_query_var( 'paged' )) {
    $paged = get_query_var( 'paged' );
} elseif (get_query_var( 'page' )) {
    $paged = get_query_var( 'page' );
} else {
    $paged = '1';
}

get_header();

?>

<section>
    <div class="container">
        <div class="d-block bg-black text-white px-3 pt-3">
			<h5 class="text-white text-center text-uppercase mb-3 mb-lg-0">
				<span>
					<?php
					$nTitle = ucwords( str_replace( '-', ' ', get_query_var( 'category_name' ) ) );

					echo ( $nTitle == 'Cara Bermain' ) ? $nTitle . ' CUCUTOTO' : $nTitle;
					?>
				</span>
			</h5>
		</div>
		<div class="d-block bg-black text-white p-3">
			<hr class="w-75 d-block mx-auto mt-0">
			<?php if ( have_posts() ) : ?>
			<div class="row g-0">
				<?php while ( have_posts() ) : the_post(); ?>
				<div class="col-12 col-lg-3 px-3 px-lg-1 mb-4">
					<?php
					$post_id = get_the_ID();
					$post_title  = explode( '|', str_replace( '&#8211;', '|', get_the_title( $post_id ) ) );
					$post_images = get_the_post_thumbnail_url( $post_id );
					$default_img = get_stylesheet_directory_uri() . '/assets/images/bg-prediksi.jpg';
					?>
					<div class="card card-post bg-gradient-2 border-0 px-1 py-1 mb-2">
						<div class="card-title px-3 py-2 mb-0">
							<p class="text-white text-center text-uppercase font-weight-bold mb-1">
								<span><?php echo $post_title[0]; ?></span>
							</p>
							<p class="text-white text-center text-uppercase font-weight-bold mb-0">
								<span><i class="fa fa-calendar-alt"></i>&nbsp;</span>
								<span><?php echo get_the_date( 'l, d M Y' ); ?></span>
							</p>
						</div>
						<div class="card-body bg-color-2 border-0 text-white px-0 py-0">
							<div class="card-thumbnail">
								<img class="w-100" src="<?php echo ( ($post_images == null) ? $default_img : $post_images ); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
							</div>
							<div class="card-content px-3 py-3">
								<p class="text-white text-justify mb-0">
									<small class="text-white"><?php echo substr( get_the_excerpt( $post_id ), 0, 150 ); ?> . . .</small>
								</p>
							</div>
						</div>
						<div class="card-footer bg-color-2 border-0 px-0 pt-0 pb-3">
							<div class="row no-gutters justify-content-center">
								<div class="col-auto">
									<a class="btn btn-warning border-0 font-weight-bold py-2 px-3 my-0" href="<?php echo get_the_permalink( $post_id ); ?>">
										<span>Lihat selengkapnya</span>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php endwhile; ?>
			</div>
			<?php endif; ?>

			<div class="row no-gutters justify-content-center px-3 px-lg-1">
				<div class="col-auto text-right">
					<?php previous_posts_link( '← Prev' ); ?>
				</div>
				<div class="col-auto text-left">
					<?php next_posts_link( 'Next →' ); ?>
				</div>
			</div>
        </div>
    </div>
</section>

<?php

get_footer();
