<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

define( 'EXCPATH', dirname( __FILE__ ) );
define( 'TXTDOMAIN', 'web-prediksi' );

require_once get_stylesheet_directory() . '/includes/bootstrap-navwalker.php';

function web_logo( $class = null ) {
    $img_logo  = wp_get_attachment_image_src( get_theme_mod( 'custom_logo' ) , 'full' );
    $img_class = ( $class == null ) ? '' : ' ' . $class;
    return '<img alt="Logo" class="web-logo' . $img_class . '" src="' . ($img_logo == null ? '' : $img_logo[0]) . '">';
}

function web_copyright( $date = '2000' ) {
    return __( 'Copyright', TXTDOMAIN ) . ' &copy; ' . date( 'Y' ) . ' <a class="site-url text-white text-decoration-none" href="/">' . get_bloginfo( 'name' ) . '</a>, All Rights Reserved.';
}


add_action( 'after_setup_theme', function () {
    add_theme_support( 'custom-logo' );
    add_theme_support( 'custom-background' );
    add_theme_support( 'post-thumbnails' );
    add_theme_support( 'title-tag' );
    
    load_theme_textdomain( TXTDOMAIN );
} );

add_action( 'widgets_init', function () {
    register_sidebar([
        'name'          => 'Header Banner',
        'id'            => 'header_banner',
        'description'   => 'List of header banner',
        'before_widget' => '<li class="splide__slide">',
        'after_widget'  => '</li>',
        'before_title'  => '<div class="d-none">',
        'after_title'   => '</div>',
    ]);
    
    register_sidebar([
        'name'          => 'Promo Banner',
        'id'            => 'promo_banner',
        'description'   => 'List of promo banner',
        'before_widget' => '',
        'after_widget'  => '',
        'before_title'  => '<div class="d-none">',
        'after_title'   => '</div>',
    ]);

    register_sidebar([
        'name'          => 'Running Text',
        'id'            => 'running_text',
        'description'   => 'Widget Running Text',
        'before_widget' => '',
        'after_widget'  => '',
        'before_title'  => '<div class="d-none">',
        'after_title'   => '</div>',
    ]);
} );


function posts_link_attributes() {
	return 'class="btn btn-sm btn-warning"';
}
add_filter( 'next_posts_link_attributes', 'posts_link_attributes' );
add_filter( 'previous_posts_link_attributes', 'posts_link_attributes' );
