<?php
/**
 * @package web-luckyspin
 * @since 1.0.0
 */

$links = [
    [ 'title' => 'Scraping', 'name' => 'moneysite_scrape' ],
    [ 'title' => 'Scraping V2', 'name' => 'moneysite_scrape_v2' ],
    [ 'title' => 'Login', 'name' => 'moneysite_login' ],
    [ 'title' => 'Daftar', 'name' => 'moneysite_daftar' ],
    [ 'title' => 'Download APK', 'name' => 'moneysite_download' ],
    [ 'title' => 'Telegram', 'name' => 'moneysite_telegram' ],
    [ 'title' => 'Whatsapp', 'name' => 'moneysite_whatsapp' ],
    [ 'title' => 'Livechat', 'name' => 'moneysite_livechat' ],
    [ 'title' => 'Bukti JP', 'name' => 'moneysite_bukti_jp' ],
    [ 'title' => 'RTP Slot', 'name' => 'moneysite_rtp_slot' ],
    [ 'title' => 'Promosi', 'name' => 'moneysite_promosi' ],
    [ 'title' => 'Keluhan', 'name' => 'moneysite_keluhan' ],
    [ 'title' => 'Panduan', 'name' => 'moneysite_panduan' ],
];

if ( isset( $_POST['save_link_moneysite'] ) ) {
    foreach ( $links as $link ) {
        update_option( $link['name'], $_POST[ $link['name'] ], true );
    }
} else {

}

settings_errors();

?>

<div class="wrap">
    <h1>Settings - Link MoneySite</h1>
    <div id="poststuff">
        <div id="post-body" class="metabox-holder columns-1">
            <div id="normal-sortables" class="meta-box-sortables ui-sortable">
                <div id="postbox-container-2" class="postbox-container">
                    <form class="postbox acf-postbox" method="post" action="">
                        <div class="postbox-header">
                            <h2 class="hndle ui-sortable-handle">Form Setting</h2>
                        </div>
                        <div class="inside acf-fields -left">
                            <?php foreach ( $links as $link ) : ?>
                                <div class="acf-field acf-field-select">
                                    <div class="acf-label">
                                        <label>Link <?= $link['title']; ?></label>
                                        <p class="description">Silahkan masukan URL <?= $link['title']; ?></p>
                                    </div>
                                    <div class="acf-input">
                                        <div class="acf-input-wrap">
                                            <input type="text" name="<?= $link['name']; ?>" value="<?= get_option( $link['name'] ); ?>" required>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                            <div id="major-publishing-actions">
                                <button type="submit" name="save_link_moneysite" class="button button-primary button-large add-field">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style type="text/css">
    .media-upload-form .notice, .media-upload-form div.error, .wrap .notice, .wrap div.error, .wrap div.updated {
        margin: 5px !important;
    }
</style>

