<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

$data_pasaran = $wlg->pasaran->get_by_name( $pasaran );
$data_livedraw = $wlg->pasaran->get_livedraw( $pasaran );

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <!-- wp_head -->
        <?php wp_head(); ?>
        <!-- meta -->
        <meta charset="<?php echo get_bloginfo('charset'); ?>">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
        <meta name="description" content="<?php echo get_bloginfo('description'); ?>">
        <meta http-equiv="refresh" content="5">
        <!-- link -->
        <link rel="shortcut icon" href="<?php echo get_site_icon_url(); ?>">
        <!-- style -->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.1/css/all.min.css">
        <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/css/style.css">
        <style type="text/css">
            .livedraw-wrapper {
                display: block;
                position: relative;
                margin: 0 auto;
                width: 100%;
                max-width: 515px;
            }
            .livedraw-thumbnail {
                display: block;
                position: relative;
                margin: 0 auto;
                max-width: 90px;
            }
            .livedraw-thumbnail img {
                display: block;
                position: relative;
                width: 100%;
                border-radius: 12px;
            }
        </style>
        <!-- script -->
        <script src="https://cdn.jsdelivr.net/npm/jquery@3.2.1/dist/jquery.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
        <script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/js/clock.js"></script>
        <script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/js/script.js"></script>
    </head>

    <body <?php body_class(); ?>>
        <section>
            <div class="container">
                <div class="livedraw-wrapper">
                    <div class="d-block bg-black text-white px-3 py-3">
                        <div class="logo-wrapper pb-2">
                            <a href="<?php echo site_url(); ?>"><?php echo web_logo(); ?></a>
                        </div>
                    </div>
                    <div class="d-block bg-color-1 p-3">
                        <div class="row align-items-center mb-4">
                            <div class="col-4">
                                <div class="livedraw-thumbnail">
                                    <img src="<?php echo get_the_post_thumbnail_url( $data_pasaran->ID ); ?>" alt="<?php echo $pasaran; ?>">
                                </div>
                            </div>
                            <div class="col-8">
                                <h3 class="text-white text-center">
                                    <span><?php echo 'Live Draw ' . $data_pasaran->post_title; ?></span>
                                    <br>
                                    <span><?php echo get_bloginfo( 'name' ); ?></span>
                                </h3>
                            </div>
                        </div>
                        <table class="table table-bordered text-white text-center mb-3">
                            <tbody>
                                <tr>
                                    <td>
                                        <h4 class="mb-0">
                                            <span><?php echo $data_livedraw['tanggal']; ?></span>
                                        </h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <?php
                            $tpl_file = WLG_PATH . '/templates/livedraw/livedraw-';

                            if ( file_exists( $tpl_file . $pasaran . '.php' ) ) {
                                require_once $tpl_file . $pasaran . '.php';
                            } else {
                                require_once $tpl_file . 'default.php';
                            }
                        ?>
                    </div>
                </div>
            </div>
            <div class="container">
                <p class="text-copyright text-white text-center mb-0 p-4">
                    <small><?php echo web_copyright(); ?></small>
                </p>
            </div>
        </section>

        <!-- wp_footer -->
        <?php wp_footer(); ?>
        
        <script type="text/javascript">
        </script>
    </body>
</html>
