<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

function wlg_format_toto_wuhan( $data, $pasaran ) {
    $list = [];

    foreach ( $data as $item ) {
        $key = $item['tanggal'];

        if ( array_key_exists( $key, $list ) ) {
            array_push( $list[$key], $item );
        } else {
            $list[$key][] = $item;
        }
    }

    if ( str_contains( $pasaran, '1' ) ) {
        $match = 1;
    } else if ( str_contains( $pasaran, '2' ) ) {
        $match = 2;
    } else if ( str_contains( $pasaran, '3' ) ) {
        $match = 3;
    } else if ( str_contains( $pasaran, '4' ) ) {
        $match = 4;
    } else if ( str_contains( $pasaran, '5' ) ) {
        $match = 5;
    } else if ( str_contains( $pasaran, '6' ) ) {
        $match = 0;
    }

    $output = [];

    foreach ( $list as $key => $val ) {
        if ( array_key_exists( $match, $val ) ) {
            if ( count( $val ) > 1 ) {
                $mix = array_reverse( $val );
            
                $output[] = $mix[$match];
            } else {
                $output[] = $val[$match];
            }
        }
    }

    return $output;
}