<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

if ( !function_exists( 'wlg_generate_json_file' ) ) {
    function wlg_generate_json_file( $json_path, $list_data ) {
        $json_file = fopen( $json_path, 'wa+' );
    
        fwrite( $json_file, json_encode( $list_data, true ) );
        fclose( $json_file );
    }
}

if ( !function_exists( 'wlg_read_json_file' ) ) {
    function wlg_read_json_file( $json_path ) {
        if ( file_exists( $json_path ) ) {
            return json_decode( file_get_contents( $json_path ), true );
        }

        return [];
    }
}

if ( !function_exists( 'wlg_update_json_file' ) ) {
    function wlg_update_json_file( $json_path, $old_data, $new_data, $key_data = null ) {
        if ( file_exists( $json_path ) ) {
            if ( $key_data == null ) {
                array_pop( $old_data );
    
                wlg_generate_json_file( $json_path, array_merge( [ $new_data ], $old_data ) );
            } else {
                $mix_data = [ $key_data => $new_data ] + $old_data;
            
                unset( $mix_data[ array_key_last( $mix_data ) ] );
    
                wlg_generate_json_file( $json_path, $mix_data );
            }
        }
    }
}

if ( !function_exists( 'wlg_add_metabox_classes' ) ) {
    function wlg_add_metabox_classes( $classes ) {
        array_push( $classes, 'acf-postbox' );
        return $classes;
    }
}

if ( !function_exists( 'wlg_get_older_post' ) ) {
    function wlg_get_older_post( $category_name, $status = 'publish', $limit = 1 ) {
        $posts = get_posts([ 'numberposts' => $limit, 'category_name' => $category_name, 'post_status' => $status ]);
        return ( $posts == null ) ? null : ( ( $limit == 1 ) ? $posts[0] : $posts );
    }
}

if ( !function_exists( 'wlg_scrape_result' ) ) {
    function wlg_scrape_result( $link, $code, $time, $history = true ) {
        if ( $code == 'p1000' ) {
            return [];
        }

        $numb = 0;
        $list = [];
        $name = 'ilhamtest678';
        $pass = 'f84add4dd5c68e332dc3244e2552be1e';
        $file = WLG_PATH . '/cookies/' . md5( $name ) . '.txt';
        $curl = curl_init();

        if ( !file_exists( $file ) ) {
            $fh = fopen( $file, "w+" );
            fwrite( $fh, "" );
            fclose( $fh );
        }

        curl_setopt_array( $curl, [
            CURLOPT_URL            => $link . 'json/post/ceklogin',
            CURLOPT_USERAGENT      => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.89 Safari/537.36',
            CURLOPT_COOKIEJAR      => $file,
            CURLOPT_COOKIEFILE     => $file,
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => '{"entered_login":"'.$name.'","entered_password":"'.$name.'"}',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_AUTOREFERER    => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_VERBOSE        => true,
            CURLOPT_HTTPHEADER     => [ 'Content-Type:application/json' ]
        ] );
        curl_exec( $curl );

        for ( $n = 1; $n <= ( $history == false ? 1 : ( $code == 'm17' ? 50 : 30 ) ); $n++ ) {
            curl_setopt_array( $curl, [
                CURLOPT_URL            => $link . 'history/detail/data/'.$code.'-'.$n,
                CURLOPT_USERAGENT      => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.89 Safari/537.36',
                CURLOPT_COOKIEJAR      => $file,
                CURLOPT_COOKIEFILE     => $file,
                CURLOPT_POST           => false,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_AUTOREFERER    => true,
                CURLOPT_FOLLOWLOCATION => true,
            ] );
            $json = json_decode( curl_exec( $curl ), true );

            foreach ( (array)$json['angka_keluar']['data'] as $data ) {
                if ( $code == 'm17' || $code == 'm53' || $code == 'm83' ) {
                    $tgl = explode( '-', substr( $data['tglangka'], 0, 10 ) );
                    $list[$numb] = [
                        'jam'     => date( 'H:i', strtotime( $time ) ) . ' WIB',
                        'hari'    => ucwords( date_i18n( 'l', strtotime( date( $tgl[2].'-'.$tgl[1].'-'.$tgl[0] ) ) ) ),
                        'tanggal' => date_i18n( 'Y-m-d', strtotime( date( $tgl[2].'-'.$tgl[1].'-'.$tgl[0] ) ) ),
                        'angka'   => substr( $data['angka'], -4 ),
                        'periode' => $data['periode'],
                    ];
                } else {
                    $tgl = explode( '-', $data['tglangka'] );
                    $list[$numb] = [
                        'jam'     => date( 'H:i', strtotime( $time ) ) . ' WIB',
                        'hari'    => ucwords( date_i18n( 'l', strtotime( date( $tgl[2].'-'.$tgl[1].'-'.$tgl[0] ) ) ) ),
                        'tanggal' => date_i18n( 'Y-m-d', strtotime( date( $tgl[2].'-'.$tgl[1].'-'.$tgl[0] ) ) ),
                        'angka'   => substr( $data['angka'], -4 ),
                        'periode' => $data['periode']
                    ];
                }

                $numb++;
            }
        }

        curl_close( $curl );
        
        session_write_close();
        
        return $list;
    }
}

if ( !function_exists( 'wlg_scrape_result_v2' ) ) {
    function wlg_scrape_result_v2( $link, $code, $time, $history = true ) {
        if ( $code == '' || $code == 'p1000' ) {
            return [];
        }

		$link = 'https://kpktotoprediksigw.com/';
        $numb = 0;
        $list = [];
        $file = WLG_PATH . '/cookies/' . md5( 'scrape-engine' ) . '.txt';
        $curl = curl_init();

        if ( !file_exists( $file ) ) {
            $fh = fopen( $file, "w+" );
            fwrite( $fh, "" );
            fclose( $fh );
        }

        for ( $no = 1; $no <= ( $history == false ? 1 : 30 ); $no++ ) {
            curl_setopt_array( $curl, [
                CURLOPT_URL            => $link . 'new-webdata.php?content=hasil&pid=' . $code . '&page=' . $no,
                CURLOPT_USERAGENT      => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.89 Safari/537.36',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYHOST => false,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_COOKIEJAR      => $file,
                CURLOPT_COOKIEFILE     => $file,
                CURLOPT_HTTPHEADER     => array("X-Requested-With: XMLHttpRequest"),
            ] );

            $html = str_get_html( curl_exec( $curl ) );

            foreach ( $html->find( 'table', 0 )->find( 'tbody', 0 )->find( 'tr' ) as $tr ) {
                $list[$numb] = [
                    'jam'     => date( 'H:i', strtotime( $time ) ) . ' WIB',
                    'hari'    => trim( $tr->find( 'td', 2 )->plaintext ),
                    'tanggal' => wlg_format_tgl_indo( trim( $tr->find( 'td', 1 )->plaintext ) ),
                    'angka'   => trim( $tr->find( 'td', 4 )->plaintext ),
                    'periode' => trim( $tr->find( 'td', 3 )->plaintext ),
                ];

                $numb++;
            }
        }

        curl_close( $curl );
        
        session_write_close();
        
        return $list;
    }
}

if ( !function_exists( 'wlg_scrape_result_ttm5d' ) ) {
    function wlg_scrape_result_ttm5d( $type, $time, $history = true ) {
        $numb = 0;
        $list = [ 'day' => [], 'eve' => [] ];
        $file = WLG_PATH . '/cookies/' . md5( 'scrape-ttm5d' ) . '.txt';
        $curl = curl_init();

        if ( !file_exists( $file ) ) {
            $fh = fopen( $file, "w+" );
            fwrite( $fh, "" );
            fclose( $fh );
        }

        curl_setopt_array( $curl, [
            CURLOPT_URL            => 'https://masterlive.net/data-totomacau5d-lengkap-' . date('Y') . '.php',
            CURLOPT_USERAGENT      => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.89 Safari/537.36',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_COOKIEJAR      => $file,
            CURLOPT_COOKIEFILE     => $file,
            CURLOPT_HTTPHEADER     => array("X-Requested-With: XMLHttpRequest"),
        ] );

        $html = str_get_html( curl_exec( $curl ) );

        curl_close( $curl );
        
        session_write_close();

        foreach ( $html->find('table[class="Tahunan-Tab-Macau"]') as $table ) {
            $hari = explode( '<br>', trim( $table->find('th', 4)->innertext) );
    
            $list['day'][] = [
                'jam'     => date( 'H:i', strtotime( $time ) ) . ' WIB',
                'hari'    => $hari[0],
                'tanggal' => wlg_format_tgl_indo( $hari[1] ),
                'angka'   => trim($table->find('td', 0)->plaintext),
                'periode' => '',
            ];
            $list['eve'][] = [
                'jam'     => date( 'H:i', strtotime( $time ) ) . ' WIB',
                'hari'    => $hari[0],
                'tanggal' => wlg_format_tgl_indo( $hari[1] ),
                'angka'   => trim($table->find('td', 1)->plaintext),
                'periode' => '',
            ];

            foreach ( $table->find('tr') as $tr ) {
                if ( $tr->find( 'td', 0 ) ) {
                    $hari = explode( '<br>', trim( $tr->find('th', 0)->innertext ) );
        
                    $list['day'][] = [
                        'jam'     => date( 'H:i', strtotime( $time ) ) . ' WIB',
                        'hari'    => $hari[0],
                        'tanggal' => wlg_format_tgl_indo( $hari[1] ),
                        'angka'   => trim( $tr->find('td', 0)->plaintext ),
                        'periode' => '',
                    ];
                    $list['eve'][] = [
                        'jam'     => date( 'H:i', strtotime( $time ) ) . ' WIB',
                        'hari'    => $hari[0],
                        'tanggal' => wlg_format_tgl_indo( $hari[1] ),
                        'angka'   => trim( $tr->find('td', 1)->plaintext ),
                        'periode' => '',
                    ];
                } 
            }
        }
        
        return ( $type == 'toto-macau-5d-01' || $type == 'toto-macau-5d-1' ) ? $list['day'] : $list['eve'];
    }
}

if ( !function_exists( 'wlg_format_paito' ) ) {
    function wlg_format_paito( $list ) {
        if ( $list != null ) {
            krsort( $list );

            $addon = 0;
            $numb  = 1;
            $skip  = 0;
            $html  = '<tr><td colspan="4" class="top"><b>Senin</b></td> <td class="asux top">D</td> <td colspan="4" class="top"><b>Selasa</b></td> <td class="asux top">D</td> <td colspan="4" class="top"><b>Rabu</b></td> <td class="asux top">D</td> <td colspan="4" class="top"><b>Kamis</b></td> <td class="asux top">D</td> <td colspan="4" class="top"><b>Jumat</b></td> <td class="asux top">D</td> <td colspan="4" class="top"><b>Sabtu</b></td> <td class="asux top">D</td> <td colspan="4" class="top"><b>Minggu</b></td> <td class="asux top">D</td></tr>';
            $html .= '<tr>';
            
            foreach ( $list as $data ) {
                if ( is_numeric( $data['angka'] ) ) {
                    if ( $skip == 0 ) {
                        switch ( $data['hari'] ) {
                            case 'Senin' :
                                $addon = 0;
                                $numb += $addon;
                            break;
                            case 'Selasa' :
                                $addon = 1;
                                $numb += $addon;
                            break;
                            case 'Rabu' :
                                $addon = 2;
                                $numb += $addon;
                            break;
                            case 'Kamis' :
                                $addon = 3;
                                $numb += $addon;
                            break;
                            case 'Jumat' :
                                $addon = 4;
                                $numb += $addon;
                            break;
                            case 'Sabtu' :
                                $addon = 5;
                                $numb += $addon;
                            break;
                            case 'Minggu' :
                                $addon = 6;
                                $numb += $addon;
                            break;
                        }
                
                        for ($i = 1; $i <= $addon; $i++) {
                            for ($n = 1; $n <= 4; $n++) {
                                $html .= '<td class="asu"></td>';
                            }
                            $html .= '<td class="asux"></td>';
                        }
    
                        $skip += 1;
                    }
                    
                    $order = (array)str_split( substr( $data['angka'], -4 ) );
                    $oddxs = intval( $order[2] + $order[3] );
                    $total = $oddxs > 9 ? (array)str_split( $oddxs ) : $oddxs;
                    $jmlh  = is_array( $total ) ? intval( $total[0] + $total[1] ) : $total;
    
                    foreach ( $order as $digit ) {
                        $html .= '<td class="asu">' . $digit . '</td>';
                    }
                    $html .= '<td class="asux">' . $jmlh . '</td>';
                    $html .= ($numb % 7 == false) ? '</tr><tr>' : '';
    
                    $numb++;
                }
            }
            
            $html .= '</tr>';
    
            return $html;
        }
    }
}

if ( !function_exists( 'wlg_format_prize' ) ) {
    function wlg_format_prize($data = [], $load = '') {
        if (isset($data['tanggal'])) {
            $data['tanggal'] = ( $data['tanggal'] == '' ) ? date( 'd M Y' ) : $data['tanggal'];
        }
        if (isset($data['prize_1'])) {
            $data['prize_1'] = is_numeric($data['prize_1']) ? $data['prize_1'] : $load;
        }
        if (isset($data['prize_2'])) {
            $data['prize_2'] = is_numeric($data['prize_2']) ? $data['prize_2'] : $load;
        }
        if (isset($data['prize_3'])) {
            $data['prize_3'] = is_numeric($data['prize_3']) ? $data['prize_3'] : $load;
        }
    
        if (isset($data['prize_4'])) {
            if (is_array($data['prize_4'])) :
                foreach ($data['prize_4'] as $key4 => $val4) {
                    $data['prize_4'][$key4] = (is_numeric($val4) ? $val4 : $load);
                }
            else :
                $data['prize_4'] = is_numeric($data['prize_4']) ? $data['prize_4'] : $load;
            endif;
        }
        if (isset($data['prize_5'])) {
            if (is_array($data['prize_5'])) :
                foreach ($data['prize_5'] as $key5 => $val5) {
                    $data['prize_5'][$key5] = (is_numeric($val5) ? $val5 : $load);
                }
            else :
                $data['prize_5'] = is_numeric($data['prize_5']) ? $data['prize_5'] : $load;
            endif;
        }
        if (isset($data['prize_6'])) {
            if (is_array($data['prize_6'])) :
                foreach ($data['prize_6'] as $key6 => $val6) {
                    $data['prize_6'][$key6] = (is_numeric($val6) ? $val6 : $load);
                }
            else :
                $data['prize_6'] = is_numeric($data['prize_6']) ? $data['prize_6'] : $load;
            endif;
        }
        if (isset($data['prize_7'])) {
            if (is_array($data['prize_7'])) :
                foreach ($data['prize_7'] as $key7 => $val7) {
                    $data['prize_7'][$key7] = (is_numeric($val7) ? $val7 : $load);
                }
            else :
                $data['prize_7'] = is_numeric($data['prize_7']) ? $data['prize_7'] : $load;
            endif;
        }
    
        return $data;
    }
}

if ( !function_exists( 'wlg_format_tgl_indo' ) ) {
    function wlg_format_tgl_indo( $text ) {
        $list = explode( ' ', $text );

        if ( $list[1] == 'Jan' || $list[1] == 'Januari' ) {
            $bulan = '01';
        } else if ( $list[1] == 'Feb' || $list[1] == 'Februari' ) {
            $bulan = '02';
        } else if ( $list[1] == 'Mar' || $list[1] == 'Maret' ) {
            $bulan = '03';
        } else if ( $list[1] == 'Apr' || $list[1] == 'April' ) {
            $bulan = '04';
        } else if ( $list[1] == 'May' || $list[1] == 'Mei' || $list[1] == 'Mei' ) {
            $bulan = '05';
        } else if ( $list[1] == 'Jun' || $list[1] == 'Juni' ) {
            $bulan = '06';
        } else if ( $list[1] == 'Jul' || $list[1] == 'Juli' ) {
            $bulan = '07';
        } else if ( $list[1] == 'Aug' || $list[1] == 'Agu' || $list[1] == 'Agustus' ) {
            $bulan = '08';
        } else if ( $list[1] == 'Sep' || $list[1] == 'September' ) {
            $bulan = '09';
        } else if ( $list[1] == 'Oct' || $list[1] == 'Okt' || $list[1] == 'Oktober' ) {
            $bulan = '10';
        } else if ( $list[1] == 'Nov' || $list[1] == 'November' ) {
            $bulan = '11';
        } else if ( $list[1] == 'Dec' || $list[1] == 'Des' || $list[1] == 'Desember' ) {
            $bulan = '12';
        }

        return $list[2] . '-' . $bulan . '-' . $list[0];
    }
}

if ( !function_exists( 'wlg_resize_uploaded_image' ) ) {
    function wlg_resize_uploaded_image( $image_data ) {
        $resizing_enabled = true;
        $force_jpeg_recompression = false;
        $compression_level = 80;
        $max_width = 1024;
        $max_height = 1024;
        $convert_png_to_jpg = true;

        if ( $convert_png_to_jpg && $image_data['type'] == 'image/png' ) {
            $image_data = wlg_convert_png_to_jpg( $image_data, $compression_level );
        }

        if( $image_data['type'] == 'image/gif' ) {
            return $image_data;
        }

        if ( $resizing_enabled || $force_jpeg_recompression ) {
            $fatal_error_reported = false;
            $valid_types = [ 'image/gif','image/png','image/jpeg','image/jpg' ];

            if ( empty( $image_data['file'] ) || empty( $image_data['type'] ) ) {
                $fatal_error_reported = true;
            } else if( !in_array( $image_data['type'], $valid_types ) ) {
                $fatal_error_reported = true;
            }

            $image_editor = wp_get_image_editor( $image_data['file'] );
            $image_type = $image_data['type'];

            if ( $fatal_error_reported || is_wp_error( $image_editor ) ) {
                return $image_data;
            } else {
                $sizes = $image_editor->get_size();

                if ( ( isset( $sizes['width'] ) && $sizes['width'] > $max_width ) || ( isset( $sizes['height'] ) && $sizes['height'] > $max_height ) ) {
                    $image_editor->resize( $max_width, $max_height, false );

                    $sizes = $image_editor->get_size();

                    $image_editor->set_quality( $compression_level );

                    $saved_image = $image_editor->save( $image_data['file'] );
                }
            }
        }

        return $image_data;
    }
}

if ( !function_exists( 'wlg_convert_png_to_jpg' ) ) {
    function wlg_convert_png_to_jpg( $image_data, $compression_level ) {
        $transparent = 0;
        $image = $image_data['file'];
        $contents = file_get_contents( $image );

        if ( ord ( file_get_contents( $image, false, null, 25, 1 ) ) & 4 ) $transparent = 1;
        if ( stripos( $contents, 'PLTE' ) !== false && stripos( $contents, 'tRNS' ) !== false ) $transparent = 1;

        $transparent_pixel = $img = $bg = false;

        if ( $transparent ) {
            $img = imagecreatefrompng( $image_data['file'] );
            $w = imagesx( $img );
            $h = imagesy( $img );

            for ( $i = 0; $i<$w; $i++ ) {
                for ( $j = 0; $j < $h; $j++ ) {
                    $rgba = imagecolorat( $img, $i, $j );

                    if ( ( $rgba & 0x7F000000 ) >> 24 ) {
                        $transparent_pixel = true;

                        break;
                    }
                }
            }
        }

        if ( !$transparent || !$transparent_pixel ) {
            if ( !$img ) $img = imagecreatefrompng( $image_data['file'] );

            $bg = imagecreatetruecolor( imagesx( $img ), imagesy( $img ) );

            imagefill( $bg, 0, 0, imagecolorallocate( $bg, 255, 255, 255 ) );
            imagealphablending( $bg, 1);
            imagecopy( $bg, $img, 0, 0, 0, 0, imagesx( $img ), imagesy( $img ) );

            $newPath = preg_replace( "/\.png$/", ".jpg", $image_data['file'] );
            $newUrl = preg_replace( "/\.png$/", ".jpg", $image_data['url'] );

            for ( $i = 1; file_exists( $newPath ); $i++ ) {
                $newPath = preg_replace("/\.png$/", "-".$i.".jpg", $image_data['file']);
            }

            if ( imagejpeg( $bg, $newPath, $compression_level ) ) {
                unlink( $image_data['file'] );

                $image_data['file'] = $newPath;
                $image_data['url'] = $newUrl;
                $image_data['type'] = 'image/jpeg';
            }
        }

        return $image_data;
    }
}
