<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

if( ! defined( 'ABSPATH' ) ) die( 'Invalid request.' );

class WLG_System
{
    var $version = '1.6.8';
    var $txtdomain = 'web-prediksi';
    var $pasaran;
    var $prediksi;
    var $winner_player = [];

    public function __construct()
    {
        $this->pasaran = new WLG_Pasaran();
        $this->prediksi = new WLG_Prediksi( pasaran: $this->pasaran );

        add_action( 'init', [ $this, 'init' ] );
        add_action( 'admin_enqueue_scripts', [ $this, 'load_assets' ] );
        add_action( 'admin_menu', [ $this->pasaran, 'submenu_page' ] );
        add_action( 'convert_pasaran', [ $this->pasaran, 'convert_all' ] );
        add_action( 'generate_result', [ $this->pasaran, 'create_result' ] );
        add_action( 'update_result', [ $this->pasaran, 'update_result' ] );
        add_action( 'generate_prediksi', [ $this->prediksi, 'create_prediksi' ] );
        add_action( 'update_prediksi', [ $this->prediksi, 'update_prediksi' ] );
        add_action( 'wlg_resize_image', [ $this, 'resize_image_all' ] );
        add_action( 'wp_ajax_wlg_page', [ $this, 'ajax_wlg_page' ] );
        add_action( 'wp_ajax_nopriv_wlg_page', [ $this, 'ajax_wlg_page' ] );
        add_action( 'wp_ajax_wlg_data', [ $this, 'ajax_wlg_data' ] );
        add_action( 'wp_ajax_nopriv_wlg_data', [ $this, 'ajax_wlg_data' ] );
        add_action( 'wp_handle_upload', [ $this, 'handle_upload' ] );

        add_filter( 'intermediate_image_sizes_advanced', [ $this, 'remove_image_sizes' ], 10, 2 );
        add_filter( 'max_srcset_image_width', [ $this, 'disable_responsive_images' ] );
    }

    public function init()
    {
        $this->pasaran->init();
        $this->prediksi->init();
        
        ( new WLG_Navbar() )->init();
        ( new WLG_Template() )->init();
    }

    public function run()
    {
        $this->pasaran->fetch_data();
        
        foreach ( (array)wlg_read_json_file( WLG_PATH . '/json/data/winner-player.json') as $player ) {
            $pasaran = $this->pasaran->get_all();

            shuffle( $pasaran );

            $this->winner_player[] = (object)[
                'name' => $player,
                'pasaran' => $pasaran[0]->post_title,
                'jackpot' => number_format( rand( 10000000, 120000000 ), 0, '', '.' ),
            ];
        }
    }

    public function handle_upload( $image_data )
    {
        return wlg_resize_uploaded_image( $image_data );
    }

    public function resize_image_all()
    {
        $begin     = new DateTime( date( '2020-01-01' ) );
        $end       = new DateTime( date( 'Y-m-d' ) );;
        $interval  = DateInterval::createFromDateString( '1 month' );
        $daterange = new DatePeriod( $begin, $interval, $end );

        $list = [];

        foreach ( $daterange as $range ) {
            $year = $range->format( 'Y' );
            $month = $range->format( 'm' );

            if ( is_dir( ABSPATH . '/wp-content/uploads/' . $year ) && is_dir( ABSPATH . '/wp-content/uploads/' . $year . '/' . $month ) ) {
                $dir_path = ABSPATH . '/wp-content/uploads/' . $year . '/' . $month;

                foreach ( (array)array_diff( scandir( $dir_path ), [ '..', '.' ] ) as $file ) {
                    $file_path = $dir_path . '/' . $file;
                    $image_editor = wp_get_image_editor( $file_path );
                    $image_size = $image_editor->get_size();

                    if ( isset( $image_size['width'] ) && $image_size['width'] > 1024 ) {
                        $image_editor->resize( 1024, 1024, false );
                        $image_editor->set_quality( 90 );
                        $image_editor->save( $file_path );
                    }
                }
            }
        }
    }

    public function remove_image_sizes( $sizes, $metadata )
    {
        return [];
    }

    public function disable_responsive_images()
    {
        return 1;
    }

    public function load_assets()
    {
        wp_enqueue_media();
        wp_register_style( 'prediksi-acf-input', plugin_dir_url( __DIR__ ) . 'assets/css/acf-input.css' );
        wp_enqueue_style( 'prediksi-acf-input' );
        wp_register_script( 'prediksi-acf-input', plugin_dir_url( __DIR__ ) . 'assets/js/prediksi-script.js' );
        wp_enqueue_script( 'prediksi-acf-input' );
    }

    public function ajax_wlg_page()
    {
        if ( isset( $_POST['action'] ) && $_POST['action'] === 'wlg_page' && isset( $_POST['path'] ) ) {
            $wlg_template = new WLG_Template();

            echo $wlg_template->get_template( $_POST['path'] );

            die();
        }
    }

    public function ajax_wlg_data()
    {
        if ( isset( $_POST['action'] ) && $_POST['action'] === 'wlg_data' && isset( $_POST['data'] ) ) {
            switch ( $_POST['data'] ) {
                case 'prediksi-togel':
                    $prediksi = ( $_POST['pasaran'] == 'all' ) ? $this->prediksi->get_all() : $this->prediksi->get_by_pasaran( $_POST['pasaran'] );

                    require_once WLG_PATH . '/templates/components/table-prediksi-togel.php';
                break;
                case 'data-keluaran-togel':
                    $time = $this->pasaran->get_by_name( $_POST['pasaran'] )->jam_tutup;
                    $results = $this->pasaran->get_result( $_POST['pasaran'], $time );

                    foreach ( $results as $key => $val ) {
                        $results[$key]['jam'] = date( 'H:i', strtotime( $time ) ) . ' WIB';
                    }

                    require_once WLG_PATH . '/templates/components/table-data-keluaran.php';
                break;
                case 'paito-togel-warna':
                    $results = $this->pasaran->get_result( $_POST['pasaran'] );

                    require_once WLG_PATH . '/templates/components/table-paito-warna.php';
                break;
            }

            die();
        }
    }
}