<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

if( ! defined( 'ABSPATH' ) ) die( 'Invalid request.' );

if ( ! class_exists( 'WP_List_Table' ) ) {
	require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class WLG_Prediksi
{
    public string $post_title = 'History Prediksi';
    public string $post_type = 'history-prediksi';
    public string $post_slug = 'history_prediksi';
    public string $menu_icon = 'dashicons-calendar-alt';
    
    var $post_prediksi;

    public function __construct( public $pasaran )
    {
    }
    
    public function init()
    {
		add_filter( 'set_screen_option', [ __CLASS__, 'set_screen' ], 10, 3 );

        $menu_prediksi = add_menu_page( $this->post_title, $this->post_title, 'manage_options', $this->post_slug, [ $this, 'callback_prediksi' ], $this->menu_icon, 7 );
        
        add_action( "load-$menu_prediksi", [ $this, 'screen_option' ] );
    }

	public static function set_screen( $status, $option, $value )
    {
		return $value;
	}

	public function screen_option()
    {
		add_screen_option( 'per_page', [ 'label' => 'Prediksi', 'default' => 10, 'option' => 'prediksi_per_page' ] );

		$this->post_prediksi = new WLG_Post_Prediksi( post_prediksi: $this->get_all() );
	}

    public function create_prediksi()
    {
        foreach ( (array)$this->pasaran->get_all() as $pasaran ) {
            $json_path = WLG_PATH . '/json/prediksi/' . $pasaran->post_name . '.json';

            if ( !file_exists( $json_path ) ) {
                $list = [];

                for ( $n = 0; $n <= 30; $n++ ) {
                    $wlg_generator = new WLG_Generator();
                    $date = date_i18n( 'Y-m-d', strtotime( '-' . $n . 'days' ) );
                    $data = $wlg_generator->generate_data( $pasaran, $date );

                    $list[$date] = $data;
                }
    
                wlg_generate_json_file( $json_path, $list );
            }
        }
    }

    public function update_prediksi()
    {
        foreach ( (array)$this->pasaran->get_all() as $pasaran ) {
            $wlg_generator = new WLG_Generator();
            $json_path = WLG_PATH . '/json/prediksi/' . $pasaran->post_name . '.json';
            $old_data = wlg_read_json_file( $json_path );
            $new_data = $wlg_generator->generate_data( $pasaran );

            if ( !array_key_exists( date_i18n( 'Y-m-d' ), $old_data ) ) {
                wlg_update_json_file( $json_path, $old_data, $new_data, date_i18n( 'Y-m-d' ) );
            }
        }
    }

    public function get_all()
    {
        $list = [];

        foreach ( (array)$this->pasaran->get_all() as $pasaran ) {
            $json = wlg_read_json_file( WLG_PATH . '/json/prediksi/' . $pasaran->post_name . '.json' );

            foreach ( $json as $data ) {
                $key = str_replace( '-', '', $data['date'] );

                if ( array_key_exists( $key, $list ) ) {
                    array_push( $list[ $key ], $data );
                } else {
                    $list[$key] = [ $data ];
                }
            }
        }

        $output = [];

        foreach ( $list as $_key => $_val ) {
            foreach ( $_val as $xval ) {
                $output[] = $xval;
            }
        }

        return $output;
    }

    public function get_by_pasaran( $pasaran )
    {
        $list = wlg_read_json_file( WLG_PATH . '/json/prediksi/' . $pasaran . '.json' );

        return $list;
    }

    public function callback_prediksi()
    {
        ?>
        <div class="wrap">
			<h2><?php echo $this->post_title; ?></h2>

			<div id="poststuff">
				<div id="post-body" class="metabox-holder">
					<div id="post-body-content">
						<div class="meta-box-sortables ui-sortable">
							<form method="post">
								<?php
                                    $this->post_prediksi->prepare_items();
                                    $this->post_prediksi->display();
                                ?>
							</form>
						</div>
					</div>
				</div>
				<br class="clear">
			</div>
		</div>
        <?php
    }
}



class WLG_Post_Prediksi extends WP_List_Table
{
    public static $list_prediksi;

    public function __construct( public $post_prediksi )
    {
        self::$list_prediksi = $post_prediksi;

        parent::__construct([ 'singular' => 'History Prediksi', 'plural' => 'History Prediksi', 'ajax' => false ]);
    }

    public static function get_prediksi( $per_page = 10, $page_number = 1 )
    {
        return array_slice( self::$list_prediksi, ( ( $page_number * $per_page ) - $per_page ), $per_page );
    }

    public static function record_count()
    {
        return count( self::$list_prediksi );
    }

	public function no_items() {
		echo 'Data Prediksi Kosong.';
	}

    public function column_default( $item, $column_name )
    {
        switch ( $column_name ) {
            case 'pasaran':
                $text  = '<div style="display:flex;gap:0 10px;">';
                $text .= '<img style="display:block;" width="120px" src="' . get_the_post_thumbnail_url( $item['id_pasaran'] ) . '">';
                $text .= '<div>';
                $text .= '<h3 style="font-weight:400;margin:0 0 5px;">' . $item['title'] . '</h3>';
                $text .= '<p style="font-weight:400;margin:0;">'. date_i18n( 'l, d M Y', strtotime( $item['date'] ) ) .'</p>';
                $text .= '</div>';
                $text .= '</div>';
                $text .= '<style>@media(min-width:1024px) {';
                $text .= '.column-pasaran {width:450px !important;} ';
                $text .= '.column-angka_main, .column-colok_bebas, .column-shio {width:120px !important;} ';
                $text .= '}</style>';

                return $text;
                return var_dump( $item );
            break;
            case 'angka_main':
                return '<h5 style="margin:0;font-size:20px;line-height:1;">' . $item['angka_main'] . '</h5>';
            case 'top_bb':
                $text  = '<p style="font-weight:400;margin:0 0 5px;">TOP 4D (BB)</p>';
                $text .= '<h5 style="margin:0 0 10px;font-size:20px;line-height:1;">' . $item['bb_4D'] . '</h5>';
                $text .= '<p style="font-weight:400;margin:0 0 5px;">TOP 3D (BB)</p>';
                $text .= '<h5 style="margin:0 0 10px;font-size:20px;line-height:1;">' . $item['bb_3D'] . '</h5>';
                $text .= '<p style="font-weight:400;margin:0 0 5px;">TOP 2D (BB)</p>';
                $text .= '<h5 style="margin:0;font-size:20px;line-height:1;">' . $item['bb_2D'] . '</h5>';

                return $text;
            break;
            case 'colok_bebas':
                $text  = '<p style="font-weight:400;margin:0 0 5px;">Colok Bebas</p>';
                $text .= '<h5 style="margin:0 0 10px;font-size:20px;line-height:1;">' . $item['colok_bebas'] . '</h5>';
                $text .= '<p style="font-weight:400;margin:0 0 5px;">Colok Bebas 2D</p>';
                $text .= '<h5 style="margin:0;font-size:20px;line-height:1;">' . $item['colok_bebas_2D'] . '</h5>';

                return $text;
            break;
            case 'shio':
                return '<h5 style="margin:0;font-size:20px;line-height:1;">' . $item['shio'] . '</h5>';
            break;
            default:
                return '';
            break;
        }
    }

	public function get_columns() {
		$columns = [
			'pasaran' => 'Pasaran',
			'angka_main' => 'Angka Main',
			'top_bb' => 'TOP 4D, 3D, 2D (BB)',
			'colok_bebas' => 'Colok Bebas',
			'shio' => 'Shio',
		];

		return $columns;
	}

	public function get_sortable_columns() {
		$sortable_columns = array(
			'pasaran' => [ 'pasaran', true ]
		);

		return $sortable_columns;
	}
    
	public function get_bulk_actions() {
		return [];
	}

    public function prepare_items()
    {
        $this->_column_headers = $this->get_column_info();

        $this->process_bulk_action();

        $per_page     = $this->get_items_per_page( 'prediksi_per_page', 10 );
        $current_page = $this->get_pagenum();
        $total_items  = self::record_count();

        $this->set_pagination_args( [
            'total_items' => $total_items,
            'per_page'    => $per_page
        ] );

        $this->items = self::get_prediksi( $per_page, $current_page );
    }
}
