<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

if( ! defined( 'ABSPATH' ) ) die( 'Invalid request.' );

class WLG_Input
{
    var $length = 'oninput="this.value=this.value.slice(0,this.maxLength)"';

    public function __construct( public $post_id, public $post_type, public $post_slug, public $post_box ) {
        echo '<script type="text/javascript">jQuery(document).ready(function($) { $("#'.$this->post_box.' .inside").addClass("acf-fields -left"); });</script>';
    }

    public function render( $input = '', $type = '', $label = '', $info = '' ) {
        $html  = '<div class="acf-field acf-field-'.$type.'">';
        $html .= '    <div class="acf-label"><label>'.$label.'</label><p class="description">'.$info.'</p></div>';
        $html .= '    <div class="acf-input"><div class="acf-input-wrap">'.$input.'</div></div>';
        $html .= '</div>';

        return $html;
    }

    public function setup_sort_order() {
        $field = $this->post_slug . '_sort_order';
        $value = get_post_meta($this->post_id, $field, true);
        $input = '<input type="number" min="1" maxlength="12" name="'.$field.'" value="'.$value.'" required="required" '.$this->length.'>';
        
        echo $this->render( $input, 'number', 'Sort Order', 'urutan tampil pasaran' );
    }

    public function setup_website_resmi() {
        $field = $this->post_slug . '_website_resmi';
        $value = get_post_meta($this->post_id, $field, true);
        $input = '<input type="text" name="'.$field.'" value="'.$value.'" required="required">';
        
        echo $this->render( $input, 'text', 'Website Resmi', 'contoh : https://hongkongpools.com' );
    }

    public function setup_jam_pasaran() {
        $field1 = $this->post_slug . '_jam_tutup';
        $field2 = $this->post_slug . '_jam_buka';
        $value1 = get_post_meta($this->post_id, $field1, true);
        $value2 = get_post_meta($this->post_id, $field2, true);

        $input  = '<fieldset>';
        $input .= '    <label style="margin-bottom:10px;display:block;">Jam Tutup Pasaran : </label>';
        $input .= '    <input type="time" name="'.$field1.'" value="'.$value1.'" required="required">';
        $input .= '    <hr style="margin: 15px 0 10px;">';
        $input .= '    <label style="margin-bottom:10px;display:block;">Jam Buka Pasaran : </label>';
        $input .= '    <input type="time" name="'.$field2.'" value="'.$value2.'" required="required">';
        $input .= '</fieldset>';
        
        echo $this->render( $input, 'time', 'Jam Pasaran', 'contoh : 14:00 PM - 14:15 PM' );
    }

    public function setup_code_scrape() {
        $field = $this->post_slug . '_code_scrape';
        $value = get_post_meta($this->post_id, $field, true);
        $input = '<input type="text" min="1" maxlength="12" name="'.$field.'" value="'.$value.'" required="required" '.$this->length.'>';
        
        echo $this->render( $input, 'text', 'Code Scrape', 'code untuk scrape data results' );
    }
}